<?php

function loadVotes ($filename) {
  global $votes; // use global $votes[]

  if (!$fp=fopen($filename, "r")) {
    echo ("Could not open $filename file");
    //if fopen returns 0, couldn't open file
    exit;
  } else {
    $file_contents = fread( $fp, filesize( $filename ) );
    fclose( $fp );
    $file_contents = trim($file_contents);
    // Place the individual lines from the file contents into $votes.
    $votes = explode ( "\n", $file_contents );
    natsort ($votes); // sort w/10 succeeding 9
  }
}

function showVotes() {
  global $votes; // use global $votes[]

  $count = count($votes);

  foreach ( $votes as $voteLine) {
    list($vote, $name) = explode ('|', $voteLine);
    echo ($vote);
    if ('' != $name) {
      echo (' (' . $name . ')');
    }

    // replace the next line with something appropriate ;-)
    $count--;
    $notLastLine = ($count > 0);
    if ($notLastLine) {
      echo (', ');
    }
  }
}

function voteAverage() {
  global $votes; // use global $votes[]
  $sum = 0.0;

  foreach ( $votes as $voteLine) {
    list($vote, $name) = explode ('|', $voteLine);
    $sum += $vote;
  }

  $average = round($sum / count ($votes), 1);

  return $average;

}

?>
